%------------------------------------------------------------------------------
% File     : PHI006^4 : TPTP v7.4.0. Released v6.4.0.
% Domain   : Philosophy
% Problem  : Inconsistency of the axioms in Goedel's original manuscript
% Version  : [Ben16] axioms : Biased.
% English  : 

% Refs     : [Ben16] Benzmueller (2016), Email to Geoff Sutcliffe
% Source   : [Ben16]
% Names    : Inconsistency_S5U_direct_fullaxioms.p [Ben16]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.67 v7.2.0, 0.62 v7.0.0, 0.57 v6.4.0
% Syntax   : Number of formulae    :   55 (   1 unit;  25 type;  23 defn)
%            Number of atoms       :  184 (  24 equality;  85 variable)
%            Maximal formula depth :   15 (   6 average)
%            Number of connectives :  110 (   4   ~;   2   |;   3   &;  98   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  150 ( 150   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   30 (  25   :;   0   =)
%            Number of variables   :   70 (   5 sgn;   6   !;   4   ?;  60   ^)
%                                         (  70   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem file has been generated by Sledgehammer.
%          : The $false conjecture makes this correspond to the Isabelle
%            sources. Otherwise it could be omitted and the status would be
%            Unsatisfiable.
%------------------------------------------------------------------------------
include('Axioms/LCL017^0.ax').
%------------------------------------------------------------------------------
%----Signature
thf(positive_tp,type,(
    positive: ( mu > $i > $o ) > $i > $o )).

thf(god_tp,type,(
    god: mu > $i > $o )).

%----Constant symbol for essence: ess
thf(essence_tp,type,(
    essence: ( mu > $i > $o ) > mu > $i > $o )).

%----Constant symbol for necessary existence: ne
thf(necessary_existence_tp,type,(
    necessary_existence: mu > $i > $o )).

%----A1: Either the property or its negation are positive, but not both.
%----(Remark: only the left to right is needed for proving T1)
thf(axA1a,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mimplies
          @ ( positive
            @ ^ [X: mu] :
                ( mnot @ ( Phi @ X ) ) )
          @ ( mnot @ ( positive @ Phi ) ) ) ) )).

thf(axA1b,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mimplies
          @ ( mnot @ ( positive @ Phi ) ) 
          @ ( positive
            @ ^ [X: mu] :
                ( mnot @ ( Phi @ X ) ) ) ) ) )).


%----A2: A property necessarily implied by a positive property is positive.
thf(axA2,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mforall_indset
          @ ^ [Psi: mu > $i > $o] :
              ( mimplies
              @ ( mand @ ( positive @ Phi )
                @ ( mbox
                  @ ( mforall_ind
                    @ ^ [X: mu] :
                        ( mimplies @ ( Phi @ X ) @ ( Psi @ X ) ) ) ) )
              @ ( positive @ Psi ) ) ) ) )).

%----D1: A God-like being possesses all positive properties.
thf(defD1,definition,
    ( god
    = ( ^ [X: mu] :
          ( mforall_indset
          @ ^ [Phi: mu > $i > $o] :
              ( mimplies @ ( positive @ Phi ) @ ( Phi @ X ) ) ) ) )).

%----A3: The property of being God-like is positive.
thf(axA3,axiom,
    ( mvalid @ ( positive @ god ) )).

%----A4: Positive properties are necessary positive properties.
thf(axA4,axiom,
    ( mvalid
    @ ( mforall_indset
      @ ^ [Phi: mu > $i > $o] :
          ( mimplies @ ( positive @ Phi ) @ ( mbox @ ( positive @ Phi ) ) ) ) )).

%----D2: An essence of an individual is a property that is
%----necessarily implying any of its properties.
thf(defD2,definition,
    ( essence
    = ( ^ [Phi: mu > $i > $o,X: mu] :
          ( mforall_indset
            @ ^ [Psi: mu > $i > $o] :
                ( mimplies @ ( Psi @ X )
                @ ( mbox
                  @ ( mforall_ind
                    @ ^ [Y: mu] :
                        ( mimplies @ ( Phi @ Y ) @ ( Psi @ Y ) ) ) ) ) ) ) )).

%----D3: Necessary existence of an entity is the exemplification of all its 
%----essences.
thf(defD3,definition,
    ( necessary_existence
    = ( ^ [X: mu] :
          ( mforall_indset
          @ ^ [Phi: mu > $i > $o] :
              ( mimplies @ ( essence @ Phi @ X )
              @ ( mbox
                @ ( mexists_ind
                  @ ^ [Y: mu] :
                      ( Phi @ Y ) ) ) ) ) ) )).

%----A5: Necessary existence is positive.
thf(axA5,axiom,
    ( mvalid @ ( positive @ necessary_existence ) )).



%---Inconsistency
thf(conj,conjecture, $false ).

%------------------------------------------------------------------------------
